/*
 * Decompiled with CFR 0.152.
 */
package jgamebase.model;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import jgamebase.Const;
import jgamebase.model.Databases;
import jgamebase.model.Path;
import jgamebase.tools.IniFileManager;
import jgamebase.tools.ListerTools;
import jgamebase.tools.StringTools;
import jgamebase.tools.SystemTools;

public class Paths {
    private static final String FILENAME_PATH = "Paths.ini";
    private static final String SECTION_GAMES = "Games";
    private static final String SECTION_MUSIC = "Music";
    private static final String SECTION_PHOTOS = "Photos";
    private static final String SECTION_SCREENSHOTS = "Screenshots";
    private static final String SECTION_EXTRAS = "Extras";
    private static Path extraPath = new Path("Extras");
    private static Path gamePath = new Path("Games");
    private static Path musicPath = new Path("Music");
    private static Path photoPath = new Path("Photos");
    private static Path screenshotPath = new Path("Screenshots");

    private Paths() {
    }

    public static File getAdditionalExtraPathId() {
        return new File(new File(Paths.getExtraPath().getDefault_rw(), "Additional"), "by-id");
    }

    public static File getAdditionalExtraPathName() {
        return new File(new File(Paths.getExtraPath().getDefault_rw(), "Additional"), "by-name");
    }

    public static File getAdditionalExtraPathId(int id) {
        return new File(Paths.getAdditionalExtraPathId(), String.format("%05d", id));
    }

    public static void createAdditionalExtraDirectories(int id, String name) {
        File dir;
        String displayId = String.format("%05d", id);
        String displayName = Paths.replaceAllSlashWithDash(name);
        String linkName = String.valueOf(displayName) + " (" + displayId + ")";
        System.out.println(linkName);
        String[] stringArray = Const.ADDEXTRAS_SUBDIRS;
        int n = Const.ADDEXTRAS_SUBDIRS.length;
        int n2 = 0;
        while (n2 < n) {
            String subdir = stringArray[n2];
            dir = new File(Paths.getAdditionalExtraPathId(id), subdir);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            ++n2;
        }
        String subdirName = StringTools.sanitize(displayName).substring(0, 1).toUpperCase();
        subdirName = subdirName.replaceAll("[0-9]", "0-9");
        dir = new File(Paths.getAdditionalExtraPathName(), subdirName);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if (!Const.OS_IS_WINDOWS && !new File(dir.getPath(), linkName).exists()) {
            String command;
            block34: {
                block32: {
                    command = new File(dir.getPath(), "mk_link.sh").toString();
                    PrintWriter out = null;
                    try {
                        try {
                            out = new PrintWriter(new File(command));
                            out.println("#!/bin/sh");
                            out.println("ln -s \"../../" + new File("by-id", displayId) + "\" \"" + linkName + "\"");
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            try {
                                if (out != null) {
                                    out.close();
                                }
                                break block32;
                            }
                            catch (Exception e2) {
                                e2.printStackTrace();
                            }
                            break block32;
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            if (out != null) {
                                out.close();
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        throw throwable;
                    }
                    try {
                        if (out != null) {
                            out.close();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                new File(command).setExecutable(true, false);
                String[] envp = SystemTools.getSystemEnvironment();
                BufferedReader stderr = null;
                try {
                    try {
                        Process process = Runtime.getRuntime().exec(command, envp, dir);
                        stderr = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                        String line = null;
                        while ((line = stderr.readLine()) != null) {
                            Const.log.info((Object)line);
                        }
                        process.waitFor();
                    }
                    catch (IOException | InterruptedException e) {
                        e.printStackTrace();
                        if (stderr != null) {
                            try {
                                stderr.close();
                            }
                            catch (IOException iOException) {}
                        }
                        break block34;
                    }
                }
                catch (Throwable throwable) {
                    if (stderr != null) {
                        try {
                            stderr.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                if (stderr != null) {
                    try {
                        stderr.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            new File(command).delete();
        }
    }

    public static void readFromIniFile() {
        File path = new File(Databases.getCurrent().getPath(), FILENAME_PATH);
        try {
            IniFileManager ini = new IniFileManager(path.toString());
            Paths.getGamePath().set(ListerTools.stringListToFileList(ini.getList(SECTION_GAMES)));
            Paths.getMusicPath().set(ListerTools.stringListToFileList(ini.getList(SECTION_MUSIC)));
            Paths.getScreenshotPath().set(ListerTools.stringListToFileList(ini.getList(SECTION_SCREENSHOTS)));
            Paths.getExtraPath().set(ListerTools.stringListToFileList(ini.getList(SECTION_EXTRAS)));
            Paths.getPhotoPath().set(ListerTools.stringListToFileList(ini.getList(SECTION_PHOTOS)));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void writeToIniFile() {
        File path = new File(Databases.getCurrent().getPath(), FILENAME_PATH);
        try {
            IniFileManager ini = new IniFileManager(path.toString());
            ini.setList(SECTION_GAMES, ListerTools.fileListToStringList(Paths.getGamePath().get()));
            ini.setList(SECTION_MUSIC, ListerTools.fileListToStringList(Paths.getMusicPath().get()));
            ini.setList(SECTION_SCREENSHOTS, ListerTools.fileListToStringList(Paths.getScreenshotPath().get()));
            ini.setList(SECTION_EXTRAS, ListerTools.fileListToStringList(Paths.getExtraPath().get()));
            ini.setList(SECTION_PHOTOS, ListerTools.fileListToStringList(Paths.getPhotoPath().get()));
            ini.save();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String backslashToSlash(String filename) {
        if (filename == null) {
            return "";
        }
        String newFilename = filename;
        while (newFilename.indexOf(92) != -1) {
            newFilename = newFilename.replace('\\', '/');
        }
        return newFilename.trim();
    }

    public static String slashToBackslash(String filename) {
        if (filename == null) {
            return "";
        }
        String newFilename = filename;
        while (newFilename.indexOf(47) != -1) {
            newFilename = newFilename.replace('/', '\\');
        }
        return newFilename.trim();
    }

    /*
     * Unable to fully structure code
     */
    public static String replaceAllSlashWithDash(String filename) {
        if (filename != null) ** GOTO lbl4
        return "";
lbl-1000:
        // 1 sources

        {
            filename = filename.replace('/', '-');
lbl4:
            // 2 sources

            ** while (filename.indexOf((int)47) != -1)
        }
lbl5:
        // 1 sources

        return filename;
    }

    public static String pathEndingWithSeparator(String path) {
        if (path == null) {
            return "";
        }
        if (!path.endsWith(File.separator)) {
            path = String.valueOf(path) + File.separator;
        }
        return path;
    }

    public static String pathEndingWithoutSeparator(String path) {
        if (path == null) {
            return "";
        }
        if (path.endsWith(File.separator)) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    public static String pathStartingWithoutSeparator(String path) {
        if (path == null) {
            return "";
        }
        if (path.startsWith(File.separator)) {
            path = path.substring(1);
        }
        return path;
    }

    public static String removePath(String filename) {
        return new File(filename).getName();
    }

    public static String getPathOnly(String filename) {
        return new File(filename).getParent() == null ? "" : new File(filename).getParent();
    }

    public static void setExtraPath(Path extraPath) {
        Paths.extraPath = extraPath;
    }

    public static Path getExtraPath() {
        return extraPath;
    }

    public static void setGamePath(Path gamePath) {
        Paths.gamePath = gamePath;
    }

    public static Path getGamePath() {
        return gamePath;
    }

    public static void setMusicPath(Path musicPath) {
        Paths.musicPath = musicPath;
    }

    public static Path getMusicPath() {
        return musicPath;
    }

    public static void setPhotoPath(Path photoPath) {
        Paths.photoPath = photoPath;
    }

    public static Path getPhotoPath() {
        return photoPath;
    }

    public static void setScreenshotPath(Path screenshotPath) {
        Paths.screenshotPath = screenshotPath;
    }

    public static Path getScreenshotPath() {
        return screenshotPath;
    }
}

